
import java.awt.*;

/** An instance of class Face is a model of a face:
    a circle with two inner circles for the eyes and
    a mouth. */
public class Face
{
private int xF; 	// The face has center (xFace,yFace)
private int yF;		// and radius rFace
private int rF;

/** Set the center of the face to (xp,yp) and the radius to rp */
public void setFace(int xp, int yp, int rp) {
	xF= xp;
	yF= yp;
	rF= rp;
	}

/** Draw the face using Graphics g */
public void drawFace(Graphics g) {
	g.drawOval(xF-rF, yF-rF, 2*rF, 2*rF);
	drawEyes(g);
	drawMouth(g);
	}

/** Draw the mouth using Graphics g -- a line 1/3 of way
    down from center and rFace/4 long */
private void drawMouth(Graphics g) {
	g.drawLine(xF-rF/8, yF+rF/3, xF+rF/8, yF+rF/3);
	}

/** Draw eyes halfway up from the center of the face and 1/3 of
    the way to the left and right of the center. The radius of
    each eye is the maximum of 1 and r/8. Use Graphics g. */
private void drawEyes(Graphics g) {
	Color c= g.getColor();
	g.setColor(Color.blue);
	
	// Calculate the y-coordinate y of the center of the eyes
	// and the radius r of the eyes
		int y= yF - rF/2;
		int r= rF/8;
		if (r < 1)
			r= 1;
	// Draw the eyes
		g.fillOval(xF-rF/3, y-r, 2*r, 2*r);
		g.fillOval(xF+rF/3, y-r, 2*r, 2*r);
	
	g.setColor(c);
	}
	
}

